/*
 * Decompiled with CFR 0.152.
 */
package scientific;

import common.util.Calculator;
import scientific.Operator;

public final class BinaryOperator
extends Operator {
    public static final int ADD_ID = 0;
    public static final int SUBSTRACT_ID = 1;
    public static final int MULTIPLY_ID = 2;
    public static final int DIVIDE_ID = 3;
    public static final int POWER_ID = 4;

    public BinaryOperator(int id) {
        super(id);
        switch (id) {
            case 0: {
                this.value = "+";
                break;
            }
            case 1: {
                this.value = "-";
                break;
            }
            case 2: {
                this.value = "x";
                break;
            }
            case 3: {
                this.value = "/";
                break;
            }
            case 4: {
                this.value = "^";
            }
        }
    }

    public double calculate(boolean isDegrees) {
        switch (this.id) {
            case 0: {
                return Calculator.getInstance().add(this.leftChild.calculate(isDegrees), this.rightChild.calculate(isDegrees));
            }
            case 1: {
                return Calculator.getInstance().substract(this.leftChild.calculate(isDegrees), this.rightChild.calculate(isDegrees));
            }
            case 2: {
                return Calculator.getInstance().multiply(this.leftChild.calculate(isDegrees), this.rightChild.calculate(isDegrees));
            }
            case 3: {
                return Calculator.getInstance().divide(this.leftChild.calculate(isDegrees), this.rightChild.calculate(isDegrees));
            }
            case 4: {
                double right = this.rightChild.calculate(isDegrees);
                if (Math.floor(right) == right) {
                    return Calculator.getInstance().pow(this.leftChild.calculate(isDegrees), (int)right);
                }
                return Calculator.getInstance().pow(this.leftChild.calculate(isDegrees), right);
            }
        }
        throw new IllegalStateException();
    }
}

